




/**********************************************************************************************
 *                                                                                            *
 * Ex1.      :   Using Command Read ASCII Distance (RA and Ra)                                *
 *               By Use Interupt Recive ASCII Distance                                        *
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU       : PIC18F8722 (ET-BASE PIC8722(ICD2))                                      *
 *                   : X-TAL : 10 MHz                                                         *
 *                   : CPU Clock = 40 MHz (x4)                                                *  
 *                                                                                            *
 * Editor-Compiler   : CCS Version 4.124                                                      *
 *                                                                                            *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                   *
 * Last Update       : 10/October/2014                                                        *
 *                                                                                            *
 * Port Interface    :  -- MCU-PIC-18F8722--           ---- ET-REMOTE DISTANCE ----           *
 *                                                                                            *
 *       UART1       :  RC6 = TX1          Connect         Rx(RS232 Port)                     *
 *                      RC7 = RX1          Connect         Tx(RS232 Port)                     *
 *                                                                                            *
 *                                                         Set JP-TTL/RS232 to RS232          *
 *                    Baud Rate = 57600 at Clock 40 Mhz    Set JP-BR (57600)                  *
 *                                                         Disable Filter                     *
 *                                                                                            *
 *           LCD     : Connect 4bit data ;LCD 16x2 by        ----LCD 16x2-----                *
 *                     RH1(output)         Connect         RS                                 *
 *                     RH2(output)         Connect         R/W                                *
 *                     RH3(output)         connect         E                                  *
 *                     RH4-RH7(output)     connect         Data 4 bit high                    *
 *                                                                                            *
 *                                                                                            *
 *       5V                                                                                   *
 *      --+--                                                                                 *
 *        |                                                                                   *
 *        +-----------------+                                                                 *
 *        |                 |                                                                 *
 *       ---                |                                                                 *
 *       |\|                |                                                                 *
 *    VR |/|<---------------|--+                                                              *
 *   10K ---                |  |  RH1 RH2 RH3           RH4   RH5    RH6    RH7               *
 *        |                 |  |   ^   ^  ^              ^     ^      ^      ^                *
 *        |                 |  |   |   |  |              |     |      |      |                *
 *        +--------------+--|--|---|---|--|--+--+--+--+  |     |      |      |                *
 *      __|__            |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *       ---             |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *        -             1| 2| 3|  4|  5| 6| 7| 8| 9|10|11|   12|    13|    14|                *
 *                     __|__|__|___|___|__|__|__|__|__|__|___ _|___ __|___ __|_               *
 *                    |  G Vcc Vo RS  R/W E D0 D1 D2 D3 D4    D5      D6    D7 |              *
 *                    |      _____________________________________________     |              *
 *                    |     |                                             |    |              *
 *                    |     |                 Module                      |    |              *
 *                    |     |           LCD 2x16 Charecter                |    |              *  
 *                    |     |_____________________________________________|    |              *
 *                    |                                                        |              *
 *                    |________________________________________________________|              *
 *                                                                                            *                                                                                           *
 *                                                                                            *
 *                                                                                            * 
 *   Operation    : Read Distance (RA-Cmm) Value Integer Display to LCD on Line 1 and         *
 *                  Read Distance (Ra-Cmm) Value Integer+Point Display to LCD on Line 2       *                                                                           *
 *                                                                                            *
 **********************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN          //Setup MCU
#use delay (clock = 40000000)                     //delay Clock = (ms)
#use rs232(baud = 57600, xmit = TX1, rcv = RX1)   //Set Rs232-CH1

#use fast_io(ALL)                                 //Stop Set direction Auto for All Port  by Compiler  


unsigned int8 distance[10],num=0  ;

//------------------LCD Function ------------------
void init_lcd(void)                   ;                // Function Initial LCD
void write_ins(unsigned int8 cmm)     ;                // Function write Command LCD
void write_data(unsigned int8 dat)    ;                // Function write data LCD
void gotolcd(unsigned int8 p)         ;                // Function Write position Curser
void EN_LCD()                         ;                // Function Enable Clock


/**********************************************************
 **                                                      **
 **      Interrupt Service Receive DATA UART1 (RX1)      **
 **                                                      **
 **********************************************************/
   
#INT_RDA
void IntRDA_isr(void)
 {  
     int8 ch ;
     
      ch = getc()                   ;  //Recive Data 
      distance[num] = ch            ;  //Keep data to Buffer Distance
                
      num++                         ;  //Increment Array Pointer      
         
      if(ch == 0x0D)                   //Check end Command
       num=0                        ;  //Clear Pointer buffer
              
 }
 


/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


 void main (void) 
  {
     unsigned int8 enter = 0x0D,k ;
    
     int8 mes1[] = {"DistanRA:     Cm"} ;
     int8 mes2[] = {"DistanRa:   . Cm"} ;


    //---------------Initial Port I/O ----------------

    //------------- Initial Port -----------
     
      set_tris_H(0x00)                ;        //Set RH(0..7) = Output for LCD Display        
      OUTPUT_H(0x00)                  ;               
      
      init_lcd()                      ;        //Initial LCD

   //----------- Print Start Message to LCD -----------

     gotolcd(0x00)                         ;  //Start Position data on LCD Line1
     for(k=0;k<16;k++)
        write_data(mes1[k])                ;  //Sent data to LCD

     gotolcd(0x40)                         ;  //Start Position data on LCD Line2
     for(k=0;k<16;k++)                           
        write_data(mes2[k])                ;  //Sent data to LCD
  
    delay_ms(200)                          ;  //Wait Module ET-Remote Distance Ready when Power On
       
       
   //---------initial Uart1 ------------

      set_tris_C(0x80)                ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out
    
      enable_interrupts(GLOBAL)       ;
      enable_interrupts(INT_RDA)      ;
      

//----------------- Start Sent Command Read Distance --------------

    while(true) 
    {   
      //################---- Sent Command RA ----#################

     //---For CMM RA Recive Data to Buffer Distance[] by Byte0 keep '#' ,Byte1-3 Keep Distance or 'Err' ,Byte4 Keep  0x0D(Enter)
     
     
     printf("*RA=%c",enter)           ;       // Sent Command Read Distance ASCII Integer  
      
      
      while((distance[0]!='#')||(distance[4]!=0x0D)){;} //Wait Recive data Check data Byte0 and Byte4
     
      
     if(distance[1]=='E')                    //Check data byte1 if is 'E'(error)  :Distance is not between 3-210 cm
       {
         gotolcd(0x09)                 ;      //Start Position data on LCD Line1
         for(k=1;k<4;k++)                          
            write_data(distance[k])    ;      //Sent Message "Err" to LCD  

      }
      else    //Distance is between 3-210 cm.
      {
          gotolcd(0x09)                ;      //Start Position data on LCD Line1
          for(k=1;k<4;k++)                          
             write_data(distance[k])   ;      //Sent Ascii Distance "xxx" to LCD
        }          


       distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
       distance[4]=0;

    
   
   
     //#########---- Sent Command Ra ----############

     //---For CMM Ra Recive Data to Buffer Distance[] by Byte0 Keep '#' ,Byte1-3 Keep Distance integer or 'Err' 
     //                                                 ,Byte4 Keep '.' or'o' ,Byte5 Keep Distance Point or 'r' 
     //                                                  Byte6 Keep 0x0D(Enter)
     
     
     printf("*Ra=%c",enter)           ;       // Sent Command Read Distance ASCII Integer+Point  
      
      
      while((distance[0]!='#')||(distance[6]!=0x0D)){;} //Wait Recive data Check data Byte0 and Byte6
     
      
     if(distance[1]=='E')                    //Check data byte1 if is 'E'(error)  :Distance is not between 3-210 cm
       {
         gotolcd(0x49)                 ;      //Start Position data on LCD Line2
         for(k=1;k<6;k++)                          
            write_data(distance[k])    ;      //Sent Message "Error" to LCD  

      }
      else    //Distance is between 3-210 cm.
      {
          gotolcd(0x49)                ;      //Start Position data on LCD Line2
          for(k=1;k<6;k++)                          
             write_data(distance[k])   ;      //Sent Ascii Distance "xxx.x" to LCD
        }          


       distance[0]=0;         //Clear Buffer keep Distance Byte Start and Byte end
       distance[6]=0;

   
   }

  }

 /**********************************************************
  **                                                      **  
  **                       Sub-Program                    ** 
  **                                                      **
  **********************************************************/

/**********************************************************
 **                                                      **
 **                        LCD Function                  **
 **                                                      **
 **********************************************************/ 
//---------- Initial LCD -----------

void init_lcd(void)
 {
  write_ins(0x33)              ;  //CMM Function Set
  write_ins(0x32)              ;  //CMM Function set
  write_ins(0x28)              ;  //CMM Function Set :DL(0)=4bit LCD ,N(1)=2 Line,F(0)= font 5x7 dot

  write_ins(0x0C)              ;  //CMM Display On/OFF :D=1,Display On
  write_ins(0x06)              ;  //CMM Entry :I/D(1)= DD RAM Address Increment,S(0) Cursor Shift
  write_ins(0x01)              ;  //CMM Clear Display
  gotolcd(0x00)                ;  //Start Address 00
 }

 //------- Enable LCD -------
 void EN_LCD()
  {
    OUTPUT_HIGH(PIN_H3)   ;  //RH3 =En = 1   
    delay_ms(1)           ;
    OUTPUT_LOW(PIN_H3)    ;  //RH3 =En = 0
    delay_ms(1)           ;
 }


//----------- Write Instruction LCD Command ------------

void write_ins(unsigned int8 cmm)
 {
  unsigned int8 com ;
  
   com = cmm & 0xF0          ; // Clear Command 4 bit Low and RS(RH1),RW(RH2)=0
   OUTPUT_H(com )            ; // Sent Command 4 Bit High to RH4..RH7
   EN_LCD()                  ; // Enable LCD
   delay_ms(3)               ;
   
   cmm = (cmm<<4) & 0xF0     ; //Shift cmm 4 bit Low to 4bit High and RS(RH1),RW(RH2)=0
   OUTPUT_H(cmm)             ; // Sent Command 4 Bit Low to RH4..RH7
   EN_LCD()                  ; // Enable LCD
   delay_ms(3)               ;

 }

//----------- Write Data LCD Command ------------

 void write_data(unsigned int8 dat)
  {
    unsigned int8 dtt ;     
  
   dtt = (dat & 0xF0)|0x02       ; //Clear data 4 bit Low and RS(RH1)=1,RW(RH2)=0
   OUTPUT_H(dtt )                ; //Sent data 4 Bit High to RH4..RH7
   EN_LCD()                      ; //Enable LCD
   delay_ms(3)                   ;
   
   dat = ((dat<<4) & 0xF0)|0x02  ; //Shift data 4 bit Low to 4bit High and RS(RH1)=1,RW(RH2)=0
   OUTPUT_H(dat)                 ; //Sent data 4 Bit Low to RH4..RH7
   EN_LCD()                      ; //Enable LCD
   delay_ms(3)                   ;

  }

//------------ Move Cursor LCD ------------

void gotolcd(unsigned int8 p)
 {
   p |= 0x80    ;
   write_ins(p) ;
 }


